FILESEXTRAPATHS_prepend := "${THISDIR}/${PN}:"

SRC_URI += "\
    file://e2fsck.conf \
    ${@bb.utils.contains('VIRTUAL-RUNTIME_net_manager','systemd','file://wired.network','',d)} \
    file://50-netfilter.conf \
"

SRC_URI += " ${@bb.utils.contains('DISTRO_FEATURES','kirkstone',' file://timedatectl_sync_status_kirkstone.patch file://Reboot_Instead_Of_Systemd_Freeze_kirkstone.patch ',' file://timedatectl_sync_status.patch ',d)} "

# enable networkd/resolved support
PACKAGECONFIG_append_pn-systemd = " \
   ${@bb.utils.contains('VIRTUAL-RUNTIME_net_manager','systemd','networkd resolved','',d)} \
"

do_install_append() {
    install -d ${D}${sysconfdir}/sysctl.d
    install -m 644 ${WORKDIR}/50-netfilter.conf ${D}${sysconfdir}/sysctl.d
    # Install /etc/e2fsck.conf to avoid boot stuck by wrong clock time
    install -m 644 -p -D ${WORKDIR}/e2fsck.conf ${D}${sysconfdir}/e2fsck.conf
    # fix the locale service to remove problematic entries on our read-only system
    sed -i -- 's/PrivateNetwork=yes//g' ${D}${systemd_unitdir}/system/systemd-localed.service

    if ${@bb.utils.contains('VIRTUAL-RUNTIME_net_manager','systemd','true','false',d)}; then
       # Install DHCP configuration for Ethernet adapters
       install -m 644 ${WORKDIR}/wired.network ${D}${sysconfdir}/systemd/network
    fi
    rm -f ${D}${base_libdir}/udev/rules.d/80-drivers.rules
    sed -i 's,kernel\.core_pattern.*,kernel.core_pattern = \|\/bin\/false,g' ${D}${sysconfdir}/sysctl.d/50-coredump.conf
}

FILES_${PN} += "${sysconfdir}/e2fsck.conf \
                ${sysconfdir}/sysctl.d/50-netfilter.conf \
               "

# SPEC-737: connmand also has a NTP client which races with systemd-timesyncd
PACKAGECONFIG_remove = "timesyncd"

# Enable systemd-coredump when agl-devel is set on
PACKAGECONFIG_append_agl-devel = " coredump"

# Add timedated to enable timedatectl
PACKAGECONFIG[timedated] = "--enable-timedated"

# Add localed to enable localectl
PACKAGECONFIG[localed] = "--enable-localed"
